﻿using PoJun.Dapper;
using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel.App
{
    /// <summary>
    /// 券流水
    /// </summary>
    public class Pub_Coupon_Flow
    {
        [Column("`Id`", ColumnKey.Primary, true)]
        public int Id { get; set; }
        /// <summary>
        /// 领取人手机号
        /// </summary>
        public string Receiptor_Phone { get; set; }
        /// <summary>
        /// 优惠券ID
        /// </summary>
        public int Coupon_Id { get; set; }
        /// <summary>
        /// 兑换码
        /// </summary>
        public string Redeem_Code { get; set; }
        /// <summary>
        /// 分享人手机号
        /// </summary>
        public string Sharing_Phone { get; set; }
        /// <summary>
        /// 有效起始日期
        /// </summary>
        public DateTime? Validity_Start_Date { get; set; }
        /// <summary>
        /// 有效截止日期
        /// </summary>
        public DateTime? Validity_End_Date { get; set; }
        /// <summary>
        /// 相应积分变化的流水号（包括兑换和推荐人奖励积分）
        /// </summary>
        public int? Integral_Flow_Id { get; set; }
        /// <summary>
        /// 次数
        /// </summary>
        public int Times { get; set; }
        /// <summary>
        /// 状态(1=删除/2=未使用/3=已使用)
        /// </summary>
        public int Status { get; set; }
        public string Create_User { get; set; }
        public DateTime? Create_Time { get; set; }
        public string Update_User { get; set; }
        public DateTime? Update_Time { get; set; }
    }
}
