﻿using ASHermed.SinoInterface.Tools;
using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel.App.Entity
{
    [TableAttibute("Pub_Authorization")]
    public class Pub_AuthorizationDto : IContentModel, IDataModel
    {
        [TableAttibute("Id")]
        public int Id { get; set; }
        public int UserId { get; set; }
        public int PatId { get; set; }
        /// <summary>
        /// 状态 1授权中 2授权超时 3授权成功 4授权不通过 5授权已失效
        /// </summary>
        public int Status { get; set; }
        public DateTime CreateTime { get; set; }
        /// <summary>
        /// 申请审核详情ID
        /// </summary>
        public string ApplyDetailIds { get; set; }
        /// <summary>
        /// 审批审核详情ID
        /// </summary>
        public string ExamineDetailIds { get; set; }
        /// <summary>
        /// 授权有效期
        /// </summary>
        public DateTime AuthorizationValidity { get; set; }
        /// <summary>
        /// 1邮件2短信
        /// </summary>
        public string AuthorizationMethod { get; set; }
        public bool IsDelete { get; set; }
        /// <summary>
        /// 是否永久授权
        /// </summary>
        public bool IsForever { get; set; }
        /// <summary>
        /// 授权时间
        /// </summary>
        public DateTime AuthorizationTime { get; set; }

        [ContentAttibute(3)]
        [TableAttibute("AuthorizationImg", 2)]
        public string AuthorizationImg { get; set; }

        [ContentAttibute(5)]
        [TableAttibute("AuthorizationPdf")]
        public string AuthorizationPdf { get; set; }
        /// <summary>
        /// 创建授权来源 1小程序 2IOS 3安卓
        /// </summary>
        public int Source { get; set; }

        /// <summary>
        /// 是否是本人
        /// </summary>
        public bool IsOneSelf { get; set; }
    }

    public class Pub_Authorization : Pub_AuthorizationDto
    {
        public List<Pub_Authorization_Detail> Detail { get; set; }
    }

}
