﻿using PoJun.Dapper;
using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel
{
    public class Out_Vaccine_Appt
    {
        [Column("`Id`", ColumnKey.Primary, true)]
        public int Id { get; set; }
        /// <summary>
        /// 流水ID
        /// </summary>
        public int FLOW_ID { get; set; }
        public int PAT_ID { get; set; }
        public int USER_ID { get; set; }
        /// <summary>
        /// 疫苗ID
        /// </summary>
        public int VACCINE_ID { get; set; }
        /// <summary>
        /// 支付方式（1=自费/2=个人商业保险）
        /// </summary>
        public int PAY_TYPE { get; set; }
        /// <summary>
        /// 是否就诊过
        /// </summary>
        public bool IS_TREATMENT { get; set; }
        /// <summary>
        /// 医保卡id
        /// </summary>
        public int INSURANCE_ID { get; set; }
        /// <summary>
        /// 保险卡号
        /// </summary>
        public string INSURANCE_NO { get; set; }
        /// <summary>
        /// 支付图片
        /// </summary>
        public string PAY_IMAGE { get; set; }
        /// <summary>
        /// HPV类型
        /// </summary>
        public string HPV_TYPE { get; set; }
        /// <summary>
        /// HPV针数
        /// </summary>
        public string HPT_PIN { get; set; }
        /// <summary>
        /// 疫苗产地  1=国产/2=进口/3均可
        /// </summary>
        public int ORIGIN { get; set; }
        /// <summary>
        /// 预约操作状态(1=已确认/2=取消/3=待处理/4=排队中)
        /// </summary>
        public int STATUS { get; set; }
        /// <summary>
        /// 匹配码（以VACCINE_APPT_开头）
        /// </summary>
        public string MATCH_CODE { get; set; }
        /// <summary>
        /// 接种时间
        /// </summary>
        public DateTime APT_TIME { get; set; }
        public int HOS_ID { get; set; }
        public int DEPT_ID { get; set; }
        public int DOC_ID { get; set; }
        /// <summary>
        /// 备注
        /// </summary>
        public string REMAKE { get; set; }
        public string CREATE_USER { get; set; }
        public DateTime CREATE_TIME { get; set; }
        public string UPDATE_USER { get; set; }
        public DateTime UPDATE_TIME { get; set; }
        /// <summary>
        /// 语言（1=中文/2=英文）
        /// </summary>
        public int LANGUAGE { get; set; }
        /// <summary>
        /// 疫苗需求类型，NULL 0:老数据 1:新数据 2:老数据清洗为新数据，与新疫苗数据一起使用
        /// </summary>
        public int NewVaccineType { get; set; }
        /// <summary>
        /// 排队号
        /// </summary>
        public int QueueNumber { get; set; }
        /// <summary>
        /// 0为普通个人预约，1企业预约
        /// </summary>
        public int Type { get; set; }
        /// <summary>
        /// 团单号
        /// </summary>
        public int GroupId { get; set; }
        public bool IsTcInterfaceError { get; set; }
}
}
