﻿using PoJun.Dapper;
using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel.App
{
    /// <summary>
    /// 文章
    /// </summary>
    public class Out_Article
    {
        [Column("`Id`", ColumnKey.Primary, true)]
        public int Id { get; set; }
        /// <summary>
        /// 标题
        /// </summary>
        public string Title { get; set; }

        /// <summary>
        /// 文章图片
        /// </summary>
        public string Cover_IMG { get; set; }
        /// <summary>
        /// 文章内容
        /// </summary>
        public string Content { get; set; }
        /// <summary>
        /// 文章类型（1=普通文章/2=视频）
        /// </summary>
        public int Content_Type { get; set; }
        /// <summary>
        /// 用户类型(1=用户/2=医生)
        /// </summary>
        public int User_Type { get; set; }
        /// <summary>
        /// 状态（0=停用/1=在用）
        /// </summary>
        public int Status { get; set; }
        /// <summary>
        /// 发布者ID,医生用户ID
        /// </summary>
        public int Create_User { get; set; }
        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime? Create_Time { get; set; }
        /// <summary>
        /// 更新人
        /// </summary>
        public int Update_User { get; set; }
        /// <summary>
        /// 更新时间
        /// </summary>
        public DateTime? Update_Time { get; set; }
        /// <summary>
        /// 文章语言版本(1=中文/2=英文)
        /// </summary>
        public int Article_Language { get; set; }



    }
}
