﻿using PoJun.Dapper;
using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel.App
{
    /// <summary>
    /// 预约表
    /// </summary>
    public class Out_Apt_Info
    {
        [Column("`Id`", ColumnKey.Primary, true)]
        public int Id { get; set; }
        /// <summary>
        /// his的预约id
        /// </summary>
        public string Episode_Id { get; set; }
        /// <summary>
        /// 患者的id
        /// </summary>
        public int Pat_Id { get; set; }
        /// <summary>
        /// 医院id
        /// </summary>
        public int Hos_Id { get; set; }
        /// <summary>
        /// 科室id
        /// </summary>
        public int Dept_ID { get; set; }
        /// <summary>
        /// 医生id
        /// </summary>
        public int Doc_Id { get; set; }
        /// <summary>
        /// 预约时间
        /// </summary>
        public DateTime? Apt_Time { get; set; }
        /// <summary>
        /// 服务项目id
        /// </summary>
        public int Apt_Proj { get; set; }
        /// <summary>
        /// 预约操作状态(0=未录入系统/1=已录入系统/2=取消/4=已确认/8=已删除)
        /// </summary>
        public int Status { get; set; }
        /// <summary>
        /// 患者状态(0未录入TC,1录入TC)
        /// </summary>
        public int Pat_Status { get; set; }
        /// <summary>
        /// 预约内部状态(1=待确认/2=取消(cancelled X)/4=已确认(booked P)/8=arrived A)/16=arrived not seen S/32=departed D/64=not show   N)
        /// </summary>
        public int Inner_Status { get; set; }
        /// <summary>
        /// 客服最后一次处理时间
        /// </summary>
        public DateTime? Dispose_Time { get; set; }
        /// <summary>
        /// 预约号源
        /// </summary>
        public string Apt_Usrn { get; set; }
        /// <summary>
        /// 备注
        /// </summary>
        public string Remark { get; set; }
        /// <summary>
        /// 申请人id
        /// </summary>
        public int Apply_User_Id { get; set; }
        /// <summary>
        /// cjsj
        /// </summary>
        public DateTime? Create_Time { get; set; }
        /// <summary>
        /// gxsj
        /// </summary>
        public DateTime? Update_Time { get; set; }
        /// <summary>
        /// 预约来源（1=平台/2=his/4=快速预约（web官网）/8=快速预约（微信官网）/16=快速预约（患者版）/32=中文/64=英文/128=特色门诊预约/256=疫苗预约/512=视频预约/1024小程序）
        /// </summary>
        public int Source_Type { get; set; }
        /// <summary>
        /// PP预约唯一匹配码
        /// </summary>
        public string Match_Code { get; set; }
        /// <summary>
        /// 取消预约原因
        /// </summary>
        public string Cancel_Remark { get; set; }
        /// <summary>
        /// 疫苗预约的话 是叫号ID
        /// </summary>
        public int Apt_Id { get; set; }
        /// <summary>
        /// 渠道1APP、2小程序、3微信、4官网 、5APP安卓、6APPIOS
        /// </summary>
        public int Channel { get; set; }
        public int QuestId { get; set; }
    }
}
