﻿using PoJun.Dapper;
using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel.App
{
    /// <summary>
    /// 医生
    /// </summary>
    public class Dic_Doctor
    {
        [Column("`Id`", ColumnKey.Primary, true)]
        public int Id { get; set; }
        /// <summary>
        /// 列表照片
        /// </summary>
        public string List_Image { get; set; }
        /// <summary>
        /// 详情图片
        /// </summary>
        public string Detail_Image { get; set; }
        /// <summary>
        /// 医生静态页面url
        /// </summary>
        public string Html_Url { get; set; }
        /// <summary>
        /// 中文名
        /// </summary>
        public string CN_Name { get; set; }
        /// <summary>
        /// 英文名
        /// </summary>
        public string EN_Name { get; set; }
        /// <summary>
        /// 中文职称
        /// </summary>
        public string CN_Title { get; set; }
        /// <summary>
        /// 英文职称
        /// </summary>
        public string EN_Title { get; set; }

        /// <summary>
        /// 中文国籍
        /// </summary>
        public string CN_Nationality { get; set; }
        /// <summary>
        /// 英文国籍
        /// </summary>
        public string EN_Nationality { get; set; }

        /// <summary>
        /// 中文擅长语言
        /// </summary>
        public string CN_Language { get; set; }
        /// <summary>
        /// 英文擅长语言
        /// </summary>
        public string EN_Language { get; set; }
        /// <summary>
        /// 中文擅长
        /// </summary>
        public string CN_Desc { get; set; }
        /// <summary>
        /// 英文擅长
        /// </summary>
        public string EN_Desc { get; set; }
        /// <summary>
        /// 中文经历
        /// </summary>
        public string CN_Exper { get; set; }
        /// <summary>
        /// 英文经历
        /// </summary>
        public string EN_Exper { get; set; }
        /// <summary>
        /// 中文学历
        /// </summary>
        public string CN_Education { get; set; }
        /// <summary>
        /// 英文学历
        /// </summary>
        public string EN_Education { get; set; }
        /// <summary>
        /// 是否明星医生
        /// </summary>
        public bool Is_Star { get; set; }
        /// <summary>
        /// 手动排序序号
        /// </summary>
        public int Sort { get; set; }
        /// <summary>
        /// 自动排序序号
        /// </summary>
        public int Sort_Index { get; set; }
        /// <summary>
        /// 选填语种
        /// </summary>
        public int Selected_Language { get; set; }
        /// <summary>
        /// cjr
        /// </summary>
        public string Create_User { get; set; }
        /// <summary>
        /// cjsj
        /// </summary>
        public DateTime Create_Time { get; set; }
        /// <summary>
        /// gxr
        /// </summary>
        public string Update_User { get; set; }
        /// <summary>
        /// gxsj
        /// </summary>
        public DateTime? Update_Time { get; set; }
        /// <summary>
        /// 是否删除
        /// </summary>
        public bool Is_Deleted { get; set; }
        /// <summary>
        /// 预约状态（1=不可预约/2=可快速预约/4=在线+快速预约）
        /// </summary>
        public int APT_Type { get; set; }
        /// <summary>
        /// 中文名拼音首字母
        /// </summary>
        public string CN_Initial { get; set; }
        /// <summary>
        /// 英文名首字母
        /// </summary>
        public string EN_Initial { get; set; }
        /// <summary>
        /// 国家id
        /// </summary>
        public string Nationality_Id { get; set; }
        /// <summary>
        /// 名称拼音
        /// </summary>
        public string Name_Pinyin { get; set; }
        /// <summary>
        /// 医生类型(1=住址医生/2=妇科医生/3=主治+妇科医生)
        /// </summary>
        public int Doctor_Type { get; set; }
    }
}
