﻿using PoJun.Dapper;
using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel.App
{
    /// <summary>
    /// 科室字典表
    /// </summary>
    public class Dic_Dept
    {
        [Column("`Id`", ColumnKey.Primary, true)]
        public int Id { get; set; }
        /// <summary>
        /// 上级科室id
        /// </summary>
        public int Parent_Id { get; set; }
        /// <summary>
        /// 科室中文名
        /// </summary>
        public string CN_Name { get; set; }
        /// <summary>
        /// 英文名
        /// </summary>
        public string EN_Name { get; set; }
        /// <summary>
        /// 中文名拼音首字母
        /// </summary>
        public string CN_Initial { get; set; }
        /// <summary>
        /// 英文名首字母
        /// </summary>
        public string EN_Initial { get; set; }
        /// <summary>
        /// 中文简介
        /// </summary>
        public string CN_Desc { get; set; }
        /// <summary>
        /// 英文简介
        /// </summary>
        public string EN_Desc { get; set; }

        /// <summary>
        /// 中文医生介绍
        /// </summary>
        public string CN_Doctor_Desc { get; set; }
        /// <summary>
        /// 英文医生介绍
        /// </summary>
        public string EN_Doctor_Desc { get; set; }
        /// <summary>
        /// 中文套餐
        /// </summary>
        public string CN_Package { get; set; }
        /// <summary>
        /// 英文套餐
        /// </summary>
        public string EN_Package { get; set; }
        /// <summary>
        /// 首页图片
        /// </summary>
        public string Home_Image { get; set; }
        /// <summary>
        /// 列表图片
        /// </summary>
        public string List_Image { get; set; }
        /// <summary>
        /// ICON(APP用)
        /// </summary>
        public string Icon { get; set; }

        /// <summary>
        /// 手动排序序号
        /// </summary>
        public int Sort { get; set; }
        /// <summary>
        /// 自动排序序号
        /// </summary>
        public int Sort_Index { get; set; }
        /// <summary>
        /// cjr
        /// </summary>
        public string Create_User { get; set; }
        /// <summary>
        /// cjsj
        /// </summary>
        public DateTime? Create_Time { get; set; }
        /// <summary>
        /// gxr
        /// </summary>
        public string Update_User { get; set; }
        /// <summary>
        /// gxsj
        /// </summary>
        public DateTime? Update_Time { get; set; }
        /// <summary>
        /// 
        /// </summary>
        public bool Is_Deleted { get; set; }
        /// <summary>
        /// 中文科室位置
        /// </summary>
        public string CN_Addr { get; set; }
        /// <summary>
        /// 英文科室位置
        /// </summary>
        public string EN_Addr { get; set; }
        /// <summary>
        /// 科室类型（0=普通科室/1=特色科室）
        /// </summary>
        public int Dept_Type { get; set; }
        /// <summary>
        /// 姓名拼英
        /// </summary>
        public string Name_Pinyin { get; set; }
        /// <summary>
        /// 是否首页展示
        /// </summary>
        public bool Is_Show_Index { get; set; }
    }
}
