﻿using PoJun.Dapper;
using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel.App
{
    /// <summary>
    /// 优惠券字典表
    /// </summary>
    public class Dic_Coupon
    {
        [Column("`Id`", ColumnKey.Primary, true)]
        public int Id { get; set; }
        /// <summary>
        /// 优惠券类型(1=普通优惠券/2=vip专属优惠券/4=赠送优惠券/8=新人券/16=ruby融创渠道券/32=宁波商会券/64=儿科邀请奖励券/128=儿科专属优惠券)
        /// </summary>
        public int Coupon_Type { get; set; }
        /// <summary>
        /// 优惠券名称
        /// </summary>
        public string CN_Coupon_Name { get; set; }
        /// <summary>
        /// 优惠券名称(英文)
        /// </summary>
        public string EN_Coupon_Name { get; set; }
        /// <summary>
        /// 优惠券图片
        /// </summary>
        public string CN_Image { get; set; }
        /// <summary>
        /// 优惠券图片(英文)
        /// </summary>
        public string EN_Image { get; set; }
        /// <summary>
        /// 兑换所需积分
        /// </summary>
        public int Price { get; set; }
        /// <summary>
        /// 有效期限
        /// </summary>
        public int Period_Of_Validity { get; set; }
        /// <summary>
        /// 有效期限单位（1=年/2=月/3=天）
        /// </summary>
        public int Period_Validity_Unit { get; set; }
        /// <summary>
        /// 有效截止日期（优惠券领取后实际截止日期，需要跟通过PERIOD_OF_VALIDITY字段计算的截止日期比较，取小）
        /// </summary>
        public DateTime? End_Validity_Date { get; set; }
        /// <summary>
        /// 优惠券总量(-1表示不限量)
        /// </summary>
        public int Total_Count { get; set; }
        /// <summary>
        /// 单人优惠券数量(-1表示不限量)
        /// </summary>
        public int Per_Count { get; set; }
        /// <summary>
        /// 单人限领单位(1=年/2=月/3=天)
        /// </summary>
        public int Single_Person_Limited_Unit { get; set; }
        /// <summary>
        /// 可使用总次数(0表示不限次)
        /// </summary>
        public int Times_Limit { get; set; }
        /// <summary>
        /// 每次使用消耗次数(弃用)
        /// </summary>
        public int Every_Using { get; set; }
        /// <summary>
        /// 优惠券状态(1=删除/2=在用/3=下架)
        /// </summary>
        public int Status { get; set; }
        public string Create_User { get; set; }
        public DateTime? Create_Time { get; set; }
        public DateTime? Update_Time { get; set; }
        public string Remark { get; set; }
        /// <summary>
        /// 中文第一个字段
        /// </summary>
        public string CN_Text_ST { get; set; }
        /// <summary>
        /// 英文第一个字段
        /// </summary>
        public string EN_Text_ST { get; set; }
        /// <summary>
        /// 中文第二个字段
        /// </summary>
        public string CN_Text_ND { get; set; }
        /// <summary>
        /// 英文第二个字段
        /// </summary>
        public string EN_Text_ND { get; set; }
        /// <summary>
        /// 中文活动说明
        /// </summary>
        public string CN_Description { get; set; }
        /// <summary>
        /// 英文活动说明
        /// </summary>
        public string EN_Description { get; set; }
    }
}
