﻿using ASHermed.SinoInterface.Enum;
using PoJun.Util;
using PoJun.Util.Helpers;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net;
using System.Net.Sockets;
using System.Reflection;
using System.Security.Cryptography;
using System.Text;

namespace ASHermed.SinoInterface.Tools
{
    /// <summary>
    /// 系统帮助类
    /// </summary>
    public static class SysUtil
    {
        #region 获取TraceId

        /// <summary>
        /// 获取TraceId
        /// </summary>
        /// <returns></returns>
        public static string GetTraceId()
        {
            if (MyHttpContext.Current == null || MyHttpContext.Current.Request == null || MyHttpContext.Current.Request.Headers == null)
                return null;
            if (MyHttpContext.Current.Request.Headers.ContainsKey(nameof(APILogConfig.PoJun_LogTraceID)))
                return MyHttpContext.Current.Request.Headers[nameof(APILogConfig.PoJun_LogTraceID)].ToString();
            return null;
        }

        #endregion

        #region 获取系统ID

        /// <summary>
        /// 获取系统ID
        /// </summary>
        /// <returns></returns>
        public static string GetSystemId()
        {
            return ConfigurationManager.AppSettings["SystemID"].ToString();
        }

        #endregion

        #region Class To Dictionary

        /// <summary>
        /// Class To Dictionary
        /// 不能转换类里面有字段类型为Class的类型的类
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="data"></param>
        /// <returns></returns>
        public static Dictionary<string, string> ClassToDictionary<T>(T data)
        {
            return Newtonsoft.Json.JsonConvert.DeserializeObject<Dictionary<string, string>>(Newtonsoft.Json.JsonConvert.SerializeObject(data));
        }

        #endregion

        #region 获取Token

        /// <summary>
        /// 获取Token
        /// </summary>
        /// <returns></returns>
        public static string GetToken()
        {
            if (MyHttpContext.Current == null || MyHttpContext.Current.Request == null || MyHttpContext.Current.Request.Headers == null)
                return null;
            if (!MyHttpContext.Current.Request.Headers.ContainsKey("Authorization"))
                return null;
            return MyHttpContext.Current.Request.Headers["Authorization"].First();
        }


        #endregion

        #region 获取客户端ID

        /// <summary>
        /// 版本
        /// </summary>
        /// <returns></returns>
        public static string GetClientId()
        {
            if (MyHttpContext.Current == null || MyHttpContext.Current.Request == null || MyHttpContext.Current.Request.Headers == null)
                return null;

            if (!MyHttpContext.Current.Request.Headers.ContainsKey("version"))
                return null;

            return MyHttpContext.Current.Request.Headers["version"].First();
        }

        #endregion

        #region 获取客户端类型

        /// <summary>
        /// 获取客户端类型
        /// </summary>
        /// <returns></returns>
        public static ClientType GetClientType()
        {
            if (MyHttpContext.Current == null || MyHttpContext.Current.Request == null || MyHttpContext.Current.Request.Headers == null)
                return ClientType.None;

            if (!MyHttpContext.Current.Request.Headers.ContainsKey("device"))
                return ClientType.None;

            var clientTypes = MyHttpContext.Current.Request.Headers["device"].First();
            var clientType = 0;
            if (clientTypes.ToLower() == "and")
            {
                clientType = 3;
            }
            if (clientTypes.ToLower() == "ios")
            {
                clientType = 2;
            }
            if (clientTypes.ToLower() == "h5")
            {
                clientType = 1;
            }
            if (clientType < 1 || clientType > 3)
                return ClientType.None;

            return (ClientType)clientType;
        }

        #endregion

        #region 获取是否为日志

        /// <summary>
        /// 获取是否为日志
        /// </summary>
        /// <returns></returns>
        public static bool GetIsLogs()
        {
            if (MyHttpContext.Current == null || MyHttpContext.Current.Request == null || MyHttpContext.Current.Request.Headers == null)
                return false;

            if (!MyHttpContext.Current.Request.Headers.ContainsKey("IsLogs"))
                return false;

            return System.Convert.ToBoolean(MyHttpContext.Current.Request.Headers["IsLogs"].First());
        }

        #endregion

        #region 签名排序

        /// <summary>
        /// 签名排序
        /// </summary>
        /// <param name="param">需要签名的DTO对象</param>
        /// <param name="delimiter">参数链接符号</param>
        /// <param name="isFieldNotNull">字段如果为空则不加入签名</param>
        /// <param name="isEncode">是否需要进行参数编码</param>
        /// <param name="signKeyHandle">签名Key处理类型</param>
        /// <returns></returns>
        public static string SignSort(Dictionary<string, string> param, string delimiter = "&", bool isFieldNotNull = false, bool isEncode = true, SignKeyHandleType signKeyHandle = SignKeyHandleType.Normal)
        {
            var signStr = string.Empty;
            foreach (var item in param.OrderBy(x => x.Key))
            {
                #region 字段如果为空则不加入签名处理

                if (isFieldNotNull)
                {
                    if (string.IsNullOrWhiteSpace(item.Value) || string.IsNullOrEmpty(item.Value))
                        continue;
                }

                #endregion

                #region 签名Key处理

                var key = item.Key;
                switch (signKeyHandle)
                {
                    case SignKeyHandleType.AllLower:
                        key = key.ToLower();
                        break;
                    case SignKeyHandleType.AllUpper:
                        key = key.ToUpper();
                        break;
                    case SignKeyHandleType.InitialLower:
                        key = $"{key.Substring(0, 1).ToLower()}{key.Substring(1, key.Length - 1)}";
                        break;
                    case SignKeyHandleType.InitialUpper:
                        key = $"{key.Substring(0, 1).ToUpper()}{key.Substring(1, key.Length - 1)}";
                        break;
                }

                #endregion

                #region 参数编码处理

                if (isEncode)
                    signStr += $"{key}={System.Net.WebUtility.UrlEncode(item.Value)}{delimiter}";
                else
                    signStr += $"{key}={item.Value}{delimiter}";

                #endregion
            }
            return signStr.Substring(0, signStr.Length - 1);
        }

        #endregion
    }
}
