﻿using RabbitMQ.Client;
using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Tools.Base
{
    public class RabbitMQConnection
    {
        public static ConnectionFactory CreateConnectFactory()
        {
            var mqConfig = RabbitMQConfig.GetInstance();
            if (mqConfig == null) { return new ConnectionFactory(); }

            return new ConnectionFactory
            {
                VirtualHost = mqConfig.VirtualHost,
                HostName = mqConfig.HostName,
                Port = mqConfig.Port,
                UserName = mqConfig.UserName,
                Password = mqConfig.Password,
                AutomaticRecoveryEnabled = true
            };
        }
    }
}
