﻿using RabbitMQ.Client;
using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Tools.Base
{
    public class InitDeclare
    {
        /// <summary>
        /// 重试的间隔时间
        /// </summary>
        private long TimeToLive = 1000 * 30;

        /// <summary>
        /// 初始化
        /// </summary>
        /// <param name="queueName"></param>
        /// <param name="timeTolive"></param>
        /// <returns></returns>
        public void Declare(string queueName, long timeTolive = 30000, bool isdelay = false)
        {
            var mqConfig = RabbitMQConfig.GetInstance();
            if (isdelay)
            {
                queueName = mqConfig.TAG + "delay_" + queueName;
            }
            else
            {
                queueName = mqConfig.TAG + queueName;
            }

            this.TimeToLive = timeTolive;
            IConnection Connection = null;
            IModel Channel = null;
            try
            {
                Connection = RabbitMQConnection.CreateConnectFactory().CreateConnection();
                Channel = Connection.CreateModel();
                Channel.BasicQos(0, 1, false);

                var retryArg = new Dictionary<string, object>();
                retryArg.Add("x-message-ttl", TimeToLive);
                if (isdelay)
                {
                    retryArg.Add("x-dead-letter-exchange", RabbitMQExchange.BUSINESS_DELAY_EXCHANGE);
                    Channel.ExchangeDeclare(RabbitMQExchange.DXL_RETRY_DELAY_EXCHANGE, ExchangeType.Fanout, true, false, null);
                    Channel.QueueDeclare(RabbitMQExchange.DXL_RETRY_DELAY_QUEUE, true, false, false, retryArg);
                    Channel.QueueBind(RabbitMQExchange.DXL_RETRY_DELAY_QUEUE, RabbitMQExchange.DXL_RETRY_DELAY_EXCHANGE, string.Empty, null);

                    var queueArg = new Dictionary<string, object>();
                    queueArg.Add("x-dead-letter-exchange", RabbitMQExchange.DXL_RETRY_DELAY_EXCHANGE);
                    var argMaps = new Dictionary<string, object>() { { "x-delayed-type", ExchangeType.Direct } };
                    Channel.ExchangeDeclare(RabbitMQExchange.BUSINESS_DELAY_EXCHANGE, "x-delayed-message", true, false, argMaps);
                    Channel.QueueDeclare(queueName, true, false, false, queueArg);
                    Channel.QueueBind(queueName, RabbitMQExchange.BUSINESS_DELAY_EXCHANGE, queueName);
                }
                else
                {
                    retryArg.Add("x-dead-letter-exchange", RabbitMQExchange.BUSINESS_EXCHANGE);
                    Channel.ExchangeDeclare(RabbitMQExchange.DXL_RETRY_EXCHANGE, ExchangeType.Fanout, true, false, null);
                    Channel.QueueDeclare(RabbitMQExchange.DXL_RETRY_QUEUE, true, false, false, retryArg);
                    Channel.QueueBind(RabbitMQExchange.DXL_RETRY_QUEUE, RabbitMQExchange.DXL_RETRY_EXCHANGE, string.Empty, null);

                    var queueArg = new Dictionary<string, object>();
                    queueArg.Add("x-dead-letter-exchange", RabbitMQExchange.DXL_RETRY_EXCHANGE);
                    Channel.ExchangeDeclare(RabbitMQExchange.BUSINESS_EXCHANGE, ExchangeType.Direct, true, false, null);
                    Channel.QueueDeclare(queueName, true, false, false, queueArg);
                    Channel.QueueBind(queueName, RabbitMQExchange.BUSINESS_EXCHANGE, queueName);
                }



            }
            catch (System.Exception ex)
            {
                //TODO 发送邮件
            }
            finally
            {
                if (Channel != null && Channel.IsOpen)
                {
                    Channel.Close();
                    Channel.Dispose();
                }
                if (Connection != null && Connection.IsOpen)
                {
                    Connection.Close();
                    Connection.Dispose();
                }
            }
        }
    }
}
