﻿using ASHermed.SinoInterface.Api.ContractModel;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;

namespace ASHermed.SinoInterface.Api.IService
{
    public interface IYouZanService
    {
        string GetYouZanToken();
        YouZanUser GetYouZanUser(string openId);
        Task<bool> YouZanUpdateUserInfo(string openId);
        YouZanResponse<CustomerInfo> GetYouZanCustomer(CustomerGetRequest model);
        YouZanResponse<CardResp> GetYouZanCard(GetCard model);
        YouZanResponse<CustomerInfo> SendYouZanCard(SendCardRequest model);

        /// <summary>
        /// 订单搜索接口 https://doc.youzanyun.com/detail/API/0/2971
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        YouZanResponse<GetTradesSoldResponse> GetTradesSold(GetTradesSoldRequest request);

        /// <summary>
        /// 单项解密
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        YouZanResponse<string> DecryptSingle(DecryptSingleRequest request);
    }
}
