﻿using System.Collections.Generic;
using System.Threading.Tasks;
using ASHermed.SinoInterface.Api.ContractModel.Quest;
using ASHermed.SinoInterface.Repository.MySql;

namespace ASHermed.SinoInterface.Api.IRepository.Quest
{
    public interface IPubQuestOptionRepository : IBaseRepositoryToASHermed_SinoInterface<Pub_Quest_Option>
    {
        /// <summary>
        /// 新增返回id
        /// </summary>
        /// <param name="questTestOption"></param>
        /// <returns></returns>
        Task<int> InsertAndReturnIdAsync(Pub_Quest_Option questTestOption);

        /// <summary>
        /// 根据id查询
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        Task<Pub_Quest_Option> GetByIdAsync(int id);

        Task<List<Pub_Quest_Option>> GetOptionForFiedid(List<int> fiedId);
        Task<int> UpdateOption(Pub_Quest_Option option);
    }
}
