﻿using System.Collections.Generic;
using System.Threading.Tasks;
using ASHermed.AdminInterface.Api.ContractModel;
using ASHermed.SinoInterface.Api.ContractModel.App.Model;
using ASHermed.SinoInterface.Api.ContractModel.Quest;
using ASHermed.SinoInterface.Repository.MySql;

namespace ASHermed.SinoInterface.Api.IRepository.Quest
{
    public interface IPubQuestInfoRepository : IBaseRepositoryToASHermed_SinoInterface<Pub_Quest_Info>
    {
        /// <summary>
        /// 新增一条，返回自增id
        /// </summary>
        /// <param name="questInfo"></param>
        /// <returns></returns>
        Task<int> InsertAnReturnIdAsync(Pub_Quest_Info questInfo);

        /// <summary>
        /// 根据id查询
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        Task<Pub_Quest_Info> GetByIdAsync(int id);

        /// <summary>
        /// 查询所有
        /// </summary>
        /// <returns></returns>
        Task<List<Pub_Quest_Info>> GetAllListAsync();

        /// <summary>
        /// 分页查询
        /// </summary>
        /// <param name="pageIndez"></param>
        /// <param name="pageSize"></param>
        /// <returns></returns>
        Task<PageListModel<Pub_Quest_Info>> GetPageListAsync(int pageIndez, int pageSize);

        Task<int> InsertConfig(Pub_Quest_Config config);
        Task<Pub_Quest_Config> GetConfig(int infoId);

        Task<List<QuestPat>> GetQuestPat(string phone);
        Task<int> UpdateInfo(Pub_Quest_Info info);
    }
}
