﻿using System.Collections.Generic;
using System.Threading.Tasks;
using ASHermed.SinoInterface.Api.ContractModel.Quest;
using ASHermed.SinoInterface.Repository.MySql;

namespace ASHermed.SinoInterface.Api.IRepository.Quest
{
    public interface IPubQuestFieIdRepository : IBaseRepositoryToASHermed_SinoInterface<Pub_Quest_FieId>
    {
        /// <summary>
        /// 新增返回id
        /// </summary>
        /// <param name="questTest"></param>
        /// <returns></returns>
        Task<int> InsertAndReturnIdAsync(Pub_Quest_FieId questTest);

        /// <summary>
        /// 根据id查询
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        Task<Pub_Quest_FieId> GetByIdAsync(int id);
        Task<Pub_Quest_FieId> GetByNameAsync(string name);

        Task<List<Pub_Quest_FieId>> GetFieIdForCateId(List<int> cateId);
        Task<int> UpdateFied(Pub_Quest_FieId fieId);
    }
}
