﻿using System;
using System.Collections.Generic;
using System.Threading.Tasks;
using ASHermed.SinoInterface.Api.ContractModel.Quest;
using ASHermed.SinoInterface.Repository.MySql;

namespace ASHermed.SinoInterface.Api.IRepository.Quest
{
    public interface IPubQuestDataRepository : IBaseRepositoryToASHermed_SinoInterface<Pub_Quest_Data>
    {
        /// <summary>
        /// 新增返回id
        /// </summary>
        /// <param name="questPatInfo"></param>
        /// <returns></returns>
        Task<int> InsertAndReturnIdAsync(Pub_Quest_Data questPatInfo);

        /// <summary>
        /// 根据id查询
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        Task<Pub_Quest_Data> GetByIdAsync(int id);

        Task<List<Pub_Quest_Data>> GetByAptId(List<int> aptIds);
        Task<List<Pub_Quest_Data>> GetByUserIdAsync(int? userid, int patId, int infoId, string pid);
        Task<List<Pub_Quest_Data>> GetByPatId3Async(int patId, int infoId);

        List<Pub_Quest_Data> GetPatQuest(int patId);
        /// <summary>
        /// 获取患者问卷填写情况(1体检 2满意度 3流调)
        /// </summary>
        /// <param name="patId"></param>
        /// <param name="infoId">1体检 2满意度 3流调</param>
        /// <returns></returns>
        List<Pub_Quest_Data> GetCurDayQuestData(int patId,int infoId);
        Pub_Quest_Data GetAptDayQuestData(int patId, int infoId, string aptCreateTime);
        List<Pub_Quest_Data> GetPatsQuest(List<int> patIds);
        List<Pub_Quest_Data> GetPatsFluQuest(List<int> patIds);
        List<Pub_Quest_Data> GetPatQuestData(int patid, int infoId, DateTime aptTime);
        List<Pub_Quest_Data> GetPhysicalQuestData(int aptId, int infoId);

    }
}
