﻿using System.Collections.Generic;
using System.Threading.Tasks;
using ASHermed.SinoInterface.Api.ContractModel.Quest;
using ASHermed.SinoInterface.Repository.MySql;

namespace ASHermed.SinoInterface.Api.IRepository.Quest
{
    public interface IPubQuestDataDetailRepository : IBaseRepositoryToASHermed_SinoInterface<Pub_Quest_DataDetail>
    {
        /// <summary>
        /// 新增返回id
        /// </summary>
        /// <param name="questPatTestInfo"></param>
        /// <returns></returns>
        Task<int> InsertAndReturnIdAsync(Pub_Quest_DataDetail questPatTestInfo);

        Task<int> InsertAsync(List<Pub_Quest_DataDetail> questPatTestInfo);

        /// <summary>
        /// 根据id查询
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        Task<Pub_Quest_DataDetail> GetByIdAsync(int id);

        Task<List<Pub_Quest_DataDetail>> GetByDataIdAsync(int dataId);
        Task<int> DeleteAsync(int dataId);

    }
}
